/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.player;

import com.creativemd.creativecore.common.config.gui.GuiPlayerSelectorButton;
import com.creativemd.creativecore.common.config.gui.SubGuiPlayerSelectorDialog;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiListBoxBase;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.player.PlayerSelector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiPlayerSelectorHandler<T extends PlayerSelector> {
    @SideOnly(value=Side.CLIENT)
    private static LinkedHashMap<String, GuiPlayerSelectorHandler> handlers = new LinkedHashMap();
    public static GuiPlayerSelectorHandler defaultHandler;
    private String name;

    public static void registerGuiSelectorHandler(String name, GuiPlayerSelectorHandler handler) {
        handler.name = name;
        handlers.put(name, handler);
    }

    public static Set<String> getNames() {
        return handlers.keySet();
    }

    public static GuiPlayerSelectorHandler getHandler(PlayerSelector selector) {
        GuiPlayerSelectorHandler handler;
        GuiPlayerSelectorHandler guiPlayerSelectorHandler = handler = selector != null ? handlers.get(PlayerSelector.get(selector.getClass())) : null;
        if (handler != null) {
            return handler;
        }
        return defaultHandler;
    }

    public static GuiPlayerSelectorHandler getHandler(String name) {
        GuiPlayerSelectorHandler handler = handlers.get(name);
        if (handler == null) {
            return defaultHandler;
        }
        return handler;
    }

    public String getName() {
        return this.name;
    }

    public abstract void createControls(SubGuiPlayerSelectorDialog var1, PlayerSelector var2);

    public abstract T parseSelector(SubGuiPlayerSelectorDialog var1);

    public void onChanged(SubGuiPlayerSelectorDialog gui, GuiControlChangedEvent event) {
    }

    static {
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("and", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorAnd>(){

            @Override
            public PlayerSelector.PlayerSelectorAnd parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorAnd(selectors);
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("or", new GuiPlayerSelectorHandlerMultiple<PlayerSelector.PlayerSelectorOr>(){

            @Override
            public PlayerSelector.PlayerSelectorOr parseSelector(PlayerSelector[] selectors) {
                return new PlayerSelector.PlayerSelectorOr(selectors);
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("not", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorNot>(){

            @Override
            public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
                gui.addControl(new GuiPlayerSelectorButton("not", 0, 30, 100, 10, selector instanceof PlayerSelector.PlayerSelectorNot ? ((PlayerSelector.PlayerSelectorNot)selector).selector : new PlayerSelector.PlayerSelectorLevel(0)));
            }

            @Override
            public PlayerSelector.PlayerSelectorNot parseSelector(SubGuiPlayerSelectorDialog gui) {
                GuiPlayerSelectorButton button = (GuiPlayerSelectorButton)gui.get("not");
                PlayerSelector selector = button.get();
                if (selector != null) {
                    return new PlayerSelector.PlayerSelectorNot(selector);
                }
                return null;
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("level", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorLevel>(){

            @Override
            public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
                gui.addControl(new GuiTextfield("content", selector instanceof PlayerSelector.PlayerSelectorLevel ? "" + ((PlayerSelector.PlayerSelectorLevel)selector).permissionLevel : "0", 0, 30, 30, 10).setNumbersOnly());
            }

            @Override
            public PlayerSelector.PlayerSelectorLevel parseSelector(SubGuiPlayerSelectorDialog gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                return new PlayerSelector.PlayerSelectorLevel(text.parseInteger());
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("mode", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorGamemode>(){

            @Override
            public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
                gui.addControl(new GuiStateButton("mode", selector instanceof PlayerSelector.PlayerSelectorGamemode ? ((PlayerSelector.PlayerSelectorGamemode)selector).type.func_77148_a() : 0, 0, 30, "survival", "creative", "adventure", "spectator"));
            }

            @Override
            public PlayerSelector.PlayerSelectorGamemode parseSelector(SubGuiPlayerSelectorDialog gui) {
                GuiStateButton mode = (GuiStateButton)gui.get("mode");
                return new PlayerSelector.PlayerSelectorGamemode(GameType.func_77146_a((int)mode.getState()));
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("command", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorCommand>(){

            @Override
            public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
                gui.addControl(new GuiTextfield("content", selector instanceof PlayerSelector.PlayerSelectorCommand ? "" + ((PlayerSelector.PlayerSelectorCommand)selector).command : "tell", 0, 30, 100, 10));
            }

            @Override
            public PlayerSelector.PlayerSelectorCommand parseSelector(SubGuiPlayerSelectorDialog gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                if (text.text.isEmpty()) {
                    return null;
                }
                return new PlayerSelector.PlayerSelectorCommand(text.text);
            }
        });
        GuiPlayerSelectorHandler.registerGuiSelectorHandler("selector", new GuiPlayerSelectorHandler<PlayerSelector.PlayerSelectorCommandSelector>(){

            @Override
            public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
                gui.addControl(new GuiTextfield("content", selector instanceof PlayerSelector.PlayerSelectorCommandSelector ? "" + ((PlayerSelector.PlayerSelectorCommandSelector)selector).pattern : "@a[]", 0, 30, 100, 10));
            }

            @Override
            public PlayerSelector.PlayerSelectorCommandSelector parseSelector(SubGuiPlayerSelectorDialog gui) {
                GuiTextfield text = (GuiTextfield)gui.get("content");
                if (text.text.isEmpty()) {
                    return null;
                }
                return new PlayerSelector.PlayerSelectorCommandSelector(text.text);
            }
        });
    }

    public static abstract class GuiPlayerSelectorHandlerMultiple<T extends PlayerSelector>
    extends GuiPlayerSelectorHandler<T> {
        public PlayerSelector[] getChildren(PlayerSelector selector) {
            if (selector instanceof PlayerSelector.PlayerSelectorAnd) {
                return ((PlayerSelector.PlayerSelectorAnd)selector).selectors;
            }
            if (selector instanceof PlayerSelector.PlayerSelectorOr) {
                return ((PlayerSelector.PlayerSelectorOr)selector).selectors;
            }
            return new PlayerSelector[]{selector};
        }

        @Override
        public void createControls(SubGuiPlayerSelectorDialog gui, PlayerSelector selector) {
            PlayerSelector[] selectors = this.getChildren(selector);
            ArrayList<GuiPlayerSelectorButton> buttons = new ArrayList<GuiPlayerSelectorButton>();
            if (selectors != null) {
                for (int i = 0; i < selectors.length; ++i) {
                    buttons.add(new GuiPlayerSelectorButton("" + i, 0, 30, 100, 10, selectors[i]));
                }
            }
            final GuiListBoxBase list = new GuiListBoxBase("list", 0, 21, 144, 100, true, buttons);
            gui.addControl(list);
            gui.addControl(new GuiButton("add", 50, 130){

                @Override
                public void onClicked(int x, int y, int button) {
                    list.add(new GuiPlayerSelectorButton("new", 0, 0, 100, 10, new PlayerSelector.PlayerSelectorLevel(0)));
                }
            });
        }

        @Override
        public T parseSelector(SubGuiPlayerSelectorDialog gui) {
            GuiListBoxBase list = (GuiListBoxBase)gui.get("list");
            PlayerSelector[] selectors = new PlayerSelector[list.size()];
            for (int i = 0; i < selectors.length; ++i) {
                selectors[i] = ((GuiPlayerSelectorButton)list.get(i)).get();
            }
            if (selectors.length > 0) {
                return this.parseSelector(selectors);
            }
            return null;
        }

        public abstract T parseSelector(PlayerSelector[] var1);
    }
}

